package race;

/**
 * Raking class represents a racing result, wich means a racing time with the
 * name of it's corresponding contender. It also extends {@link Comparable}
 * interface, thus making possible for a set of placements to be sorted
 * 
 * @author simone
 * @since 2.0
 * @version 1.2
 *
 */
public class Ranking implements Comparable<Ranking> {

	private String contenderName;
	private String raceTime;

	/**
	 * Create a new Ranking istance
	 * 
	 * @param contenderName: the name of this contender 
	 * @param raceTime: the race result of this contender
	 */
	public Ranking(String contenderName, String raceTime) {
		this.contenderName = contenderName;
		this.raceTime = raceTime;
	}

	@Override
	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(Ranking other) {
		if (Long.parseLong(raceTime) > Long.parseLong(other.raceTime)) {
			return -1;
		} else {
			return +1;
		}
	}

	/**
	 * 
	 * @return: the name of this contender
	 */
	public String getContender() {
		return contenderName;
	}

	/**
	 * 
	 * @return: the racing time of this contender
	 */
	public String getTime() {
		return raceTime;
	}

}
